;========================================================
;QUAD v.1.0 for Grzybsoniada 2011 competition
;Atari 8-bit ver.: code: nosty, music: sOnar
;compiled with XASM 3.0.2
;--------------------------------------------------------
;Original game: http://www.norbain.com/games/quad/
;--------------------------------------------------------
;I also used a picture from: http://walyou.com/3d-tetris-head-design/
;========================================================


;TODO
;+poprawa licznika punktow (ma sumowac linie pionowe i poziome)
;-znikanie lini zrobic w innej ramce niz mruganie
;+poprawa screenu tytulowego
;+zaczecie od nowa (obsluga przegranej)
;+kolorowy bar czasu klocka
;+zwiekszyc czulosc fire
;+obsluga zwyciestwa!!
;+instrukcja!!!
;+poprawa obslugi fire (eliminacja stawiania 2 klockow 1 po drugim)
;+przy przegranej i wygranej doliczyc punkty z bufora do wyniku i czas do wyniku
;+wyjscie do DOS przez ESC

;===na pozniej:
;+zmiana szerokosci czasu przy utracie klocka
;-mrugniecie przy pojawieniu sie nowego klocka na planszy
;+lepsze obroty wokol dobrej osi
;-wlaczanie/wyl. muzyki

;obszar ekranu w jednostkach pozycji graczy/pociskow (0-255).
;x: 48 do 207
;y: 32 do 223

;kod kolor
;$0x szary
;$lx zoty
;$2x pomaraczowy
;$3x czerwony
;$4x rowy
;$5x purpurowy
;$6x fioletowy
;$7x niebieski zimny
;$8x niebieski
;$9x bkitny
;$Ax turkusowy
;$Bx niebiesko-zielony
;$Cx zielony
;$Dx to-zielony
;$Ex pomaraczowp-zielony
;$Fx ty

LICZNIK  equ $14   ;RTC zwiekszany co 1/50s
sysvbv   equ $e45f ;systemowa proc VBLI
jsetvblv equ $e45c ;ustawienie wektora VBLI
NMIEN    equ $D40E ;wlaczenie przerwan
VDSLST equ $200
WSYNC equ $D40A
VCOUNT  equ $D40B

RANDOM equ $D20A

TRIG0S equ $0284 ;rejestr cien fire joya 0 - bit 0 = 0 oznacza wcisniety fire

CHBASE equ $D409 ;adres zestawu znakow (starszy bajt) ma cien CHABS - $02F4 (756)
CHBAS  equ $2F4

DMACTL equ $22F
GRACTL equ $D01D
GPRIOR equ $026F ;cien PRIOR'a
PRIOR  equ $D01B
PMBASE equ $D407
;pozycje X graczy
HPOSP0 equ $D000  ;Standardowe pole gry zajmuje pozycje 41 do 207
HPOSP1 equ $D001
HPOSP2 equ $D002
HPOSP3 equ $D003
;pozycje X pociskow
HPOSM0 equ $D004
HPOSM1 equ $D005
HPOSM2 equ $D006
HPOSM3 equ $D007
;kolory graczy
COLPM0S equ $02C0 ;cien przepisywany w VBL
COLPM0  equ $D012
COLPM1S equ $02C1
COLPM1  equ $D013
COLPM2S equ $02C2
COLPM2  equ $D014
COLPM3S equ $02C3
COLPM3  equ $D015

;rozdzielczosc duszkow
SIZEP0 equ $D008
SIZEP1 equ $D009
SIZEP2 equ $D00A
SIZEP3 equ $D00B
;rodzielczosc pociskow
SIZEM equ $D00C
;kolizje duszka z duszkiem
KOLP0P equ $D00C
KOLP1P equ $D00D
KOLP2P equ $D00E
KOLP3P equ $D00F
;kolizje pocisku z duszkiem
KOLM0P equ $D008
KOLM1P equ $D009
KOLM2P equ $D00A
KOLM3P equ $D00B

HITCLR equ $D01E ;Zapis dowolnej wartoci pod ten adres kasuje stany rejestrw kolizji.

COLOR0 equ $02C4
COLOR1 equ $02C5
COLOR2 equ $02C6
COLOR3 equ $02C7 ;kolor piatego gracza z polaczonych pociskow
COLOR4 equ $02C8 ;cien COLBAK

COLPF0 equ $D016
COLPF1 equ $D017
COLPF2 equ $D018
COLPF3 equ $D019 ;kolor piatego gracza z polaczonych pociskow
COLBAK equ $D01A ;cieniem jest COLOR4

STICK0 equ $0278 ;cien - stan joya 0

ATRACT equ $004d ;licznik wygaszacza ekranu - trzeba wstawiac 0 co jakis czas (kilkadziesiat sek.)

dliadr   equ $230
obr      equ $58


;-------------STALE----------------
do_ilu_fire equ 1 ;do ilu odliczac (od 0) zeby uznac ze fire jest wcisniety
gdzie_rys_next_klocek equ pamiec_ekranu+16*40+30 ;w ktorym miejscu pamieci rysowac nastepny klocek
pozycja_X_P0 equ 160
ile_razy_mrugnac_linia equ 5
max_licznik_klocka equ 51 ;do ilu odliczac licznik_klocka
gdzie_rys_licznik_klocka equ pmg_memory_1+$700+32+16+16+8+16+16+8+16+32
czym_wypelniac_panel equ 21 ;nr fonta
kolor_napisu_score equ $C8
kolor_napisu_time equ $98
kolor_napisu_next equ $38
;-------------ZMIENNE---------------
         org $80
_arr     equ $80
_arr2    equ $82
_arr3    equ $84
uni2     equ $85
uni3     equ $86
uni4     equ $87
klocek   equ $88   ;numer klocka aktualnie obracanego
klocek_next   equ $89   ;numer klocka nastepnego
klocek_X equ $8A   ;pozycja lewego gornego rogu klocka obracanego
klocek_Y equ $8B
klocek_adr equ $8C ;i $8D - adres lewego gornego rogu klocka obracanego
licznik_old equ $8E ;poprzednia wartosc licznika
stan_joya equ $8F
fire      equ $90
fire_licznik equ $91
czy_mozna_postawic equ $92   ;czy mozna postawic klocek 1 - tak, 0 - nie, ustawiane w postaw_klocek
wskaz_tabela_odpowiedzi_linii equ $93
mrugaj_liniami_poziomymi equ $94
mrugaj_liniami_pionowymi equ $95
licznik_czasu equ $96 ;i $97
licznik_klocka equ $98 ;ile czasu (w ramka*8) jest na polozenie klocka
punkty equ $99 ;i $9A, $9B
punkty_bufor equ $9C ;i $9D, $9E
klocek_roboczy equ $9F
czy_mrug_poziom equ $A0
kolumna_pion equ $A1
byl_fire_wycisniety equ $A2 ;0 - byl, 1 - nie byl
przesun_czas equ $A3 ;do wahniecia czasem jak klocek stracony

       ;================================
       run start

       org $2000
fonty
       ins 'quad.fnt'
       org $2400
pamiec_ekranu            ;40*24 = 960 bajtow + 40 znakow na linie ststusu = 1000 bajtw,

       org $2800
pmg_memory_1            ;pierwsze 750 bajtow wolnych
       org *+$800
;wksazy adresu pierwszego znaku w rzedzie pamieci ekranu
;wykorzystywane w szybkich operacjach na liniach pionowych
;musi sie zaczynac od pelnej strony!
wskazy_linii_obr
       dta a(pamiec_ekranu)
       dta a(pamiec_ekranu+1*40)
       dta a(pamiec_ekranu+2*40)
       dta a(pamiec_ekranu+3*40)
       dta a(pamiec_ekranu+4*40)
       dta a(pamiec_ekranu+5*40)
       dta a(pamiec_ekranu+6*40)
       dta a(pamiec_ekranu+7*40)
       dta a(pamiec_ekranu+8*40)
       dta a(pamiec_ekranu+9*40)
       dta a(pamiec_ekranu+10*40)
       dta a(pamiec_ekranu+11*40)
       dta a(pamiec_ekranu+12*40)
       dta a(pamiec_ekranu+13*40)
       dta a(pamiec_ekranu+14*40)
       dta a(pamiec_ekranu+15*40)
       dta a(pamiec_ekranu+16*40)
       dta a(pamiec_ekranu+17*40)
       dta a(pamiec_ekranu+18*40)
       dta a(pamiec_ekranu+19*40)
       dta a(pamiec_ekranu+20*40)
       dta a(pamiec_ekranu+21*40)
       dta a(pamiec_ekranu+22*40)
       dta a(pamiec_ekranu+23*40)

       org $3100
;--napisy - musza byc od pelnej strony!
napis_SCORE
       dta %01111110,%01111110,%01111100,%11111100,%11111110
       dta %01111110,%01111110,%01111100,%11111100,%11111110
       dta %11100000,%11100000,%11101110,%11001110,%11100000
       dta %11100000,%11100000,%11101110,%11001110,%11100000
       dta %01111000,%11100000,%11101110,%11111110,%11111000
       dta %01111000,%11100000,%11101110,%11111110,%11111000
       dta %00001100,%11100000,%11101110,%11111100,%11100000
       dta %00001100,%11100000,%11101110,%11111100,%11100000
       dta %11111110,%11111110,%11111110,%11011110,%11111110
       dta %11111110,%11111110,%11111110,%11011110,%11111110
       dta %11111110,%11111110,%11111110,%11011110,%11111110
       dta %11111110,%11111110,%11111110,%11011110,%11111110
       dta %11111100,%01111110,%01111100,%11011110,%11111110
       dta %11111100,%01111110,%01111100,%11011110,%11111110
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_TIME
       dta %11111110,%01111100,%11000110,%11111110,%00000000
       dta %11111110,%01111100,%11000110,%11111110,%00000000
       dta %01111100,%01111100,%11101110,%11100000,%00111000
       dta %01111100,%01111100,%11101110,%11100000,%00111000
       dta %01111100,%01111100,%11111110,%11111000,%00111000
       dta %01111100,%01111100,%11111110,%11111000,%00111000
       dta %01111100,%01111100,%11111110,%11100000,%00000000
       dta %01111100,%01111100,%11111110,%11100000,%00000000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %01111100,%01111100,%11101110,%11111110,%00111000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_NEXT
       dta %11100110,%11111110,%11110110,%11111110,%00000000
       dta %11100110,%11111110,%11110110,%11111110,%00000000
       dta %11110110,%11100000,%11110110,%01111100,%00111000
       dta %11110110,%11100000,%11110110,%01111100,%00111000
       dta %11111110,%11111000,%01111100,%01111100,%00111000
       dta %11111110,%11111000,%01111100,%01111100,%00111000
       dta %11111110,%11100000,%11111110,%01111100,%00000000
       dta %11111110,%11100000,%11111110,%01111100,%00000000
       dta %11111110,%11111110,%11011110,%01111100,%00111000
       dta %11111110,%11111110,%11011110,%01111100,%00111000
       dta %11101110,%11111110,%11011110,%01111100,%00111000
       dta %11101110,%11111110,%11011110,%01111100,%00111000
       dta %11101110,%11111110,%11011110,%01111100,%00111000
       dta %11101110,%11111110,%11011110,%01111100,%00111000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

       org $3200
;--napisy - musza byc od pelnej strony!
napis_GAME
       dta %01111110,%00111000,%11000110,%11111110,%00000000
       dta %01111110,%00111000,%11000110,%11111110,%00000000
       dta %11100000,%01111100,%11101110,%11100000,%00000000
       dta %11100000,%01111100,%11101110,%11100000,%00000000
       dta %11101110,%11110110,%11111110,%11111000,%00000000
       dta %11101110,%11110110,%11111110,%11111000,%00000000
       dta %11100110,%11111110,%11111110,%11100000,%00000000
       dta %11100110,%11111110,%11111110,%11100000,%00000000
       dta %11111110,%11110110,%11101110,%11111110,%00000000
       dta %11111110,%11110110,%11101110,%11111110,%00000000
       dta %11111110,%11110110,%11101110,%11111110,%00000000
       dta %11111110,%11110110,%11101110,%11111110,%00000000
       dta %01111110,%11110110,%11101110,%11111110,%00000000
       dta %01111110,%11110110,%11101110,%11111110,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_OVER
       dta %01111100,%11110110,%11111110,%11111100,%00000000
       dta %01111100,%11110110,%11111110,%11111100,%00000000
       dta %11101110,%11110110,%11100000,%11001110,%00000000
       dta %11101110,%11110110,%11100000,%11001110,%00000000
       dta %11101110,%11110110,%11111000,%11111110,%00000000
       dta %11101110,%11110110,%11111000,%11111110,%00000000
       dta %11101110,%11110110,%11100000,%11111100,%00000000
       dta %11101110,%11110110,%11100000,%11111100,%00000000
       dta %11111110,%11111100,%11111110,%11011110,%00000000
       dta %11111110,%11111100,%11111110,%11011110,%00000000
       dta %11111110,%01111000,%11111110,%11011110,%00000000
       dta %11111110,%01111000,%11111110,%11011110,%00000000
       dta %01111100,%00110000,%11111110,%11011110,%00000000
       dta %01111100,%00110000,%11111110,%11011110,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_PRESS    ;P        R          E          S        S
       dta %11111100,%11111100,%11111110,%01111110,%01111110
       dta %11111100,%11111100,%11111110,%01111110,%01111110
       dta %11101110,%11001110,%11100000,%11100000,%11100000
       dta %11101110,%11001110,%11100000,%11100000,%11100000
       dta %11101110,%11111110,%11111000,%01111000,%01111000
       dta %11101110,%11111110,%11111000,%01111000,%01111000
       dta %11111100,%11111100,%11100000,%00001100,%00001100
       dta %11111100,%11111100,%11100000,%00001100,%00001100
       dta %11110000,%11011110,%11111110,%11111110,%11111110
       dta %11110000,%11011110,%11111110,%11111110,%11111110
       dta %11110000,%11011110,%11111110,%11111110,%11111110
       dta %11110000,%11011110,%11111110,%11111110,%11111110
       dta %11110000,%11011110,%11111110,%11111100,%11111100
       dta %11110000,%11011110,%11111110,%11111100,%11111100
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

       org $3300
;--napisy - musza byc od pelnej strony!
napis_SPACE     ;S      P         A          C         E
       dta %01111110,%11111100,%00111000,%01111110,%11111110
       dta %01111110,%11111100,%00111000,%01111110,%11111110
       dta %11100000,%11101110,%01111100,%11100000,%11100000
       dta %11100000,%11101110,%01111100,%11100000,%11100000
       dta %01111000,%11101110,%11101110,%11100000,%11111000
       dta %01111000,%11101110,%11101110,%11100000,%11111000
       dta %00001100,%11111100,%11111110,%11100000,%11100000
       dta %00001100,%11111100,%11111110,%11100000,%11100000
       dta %11111110,%11110000,%11101110,%11111110,%11111110
       dta %11111110,%11110000,%11101110,%11111110,%11111110
       dta %11111110,%11110000,%11101110,%11111110,%11111110
       dta %11111110,%11110000,%11101110,%11111110,%11111110
       dta %11111100,%11110000,%11101110,%01111110,%11111110
       dta %11111100,%11110000,%11101110,%01111110,%11111110
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_YOU
       dta %00000000,%11101110,%01111100,%11110110,%00000000
       dta %00000000,%11101110,%01111100,%11110110,%00000000
       dta %00000000,%11101110,%11101110,%11110110,%00000000
       dta %00000000,%11101110,%11101110,%11110110,%00000000
       dta %00000000,%01111100,%11101110,%11110110,%00000000
       dta %00000000,%01111100,%11101110,%11110110,%00000000
       dta %00000000,%00111000,%11101110,%11111110,%00000000
       dta %00000000,%00111000,%11101110,%11111110,%00000000
       dta %00000000,%01111100,%11111110,%11111110,%00000000
       dta %00000000,%01111100,%11111110,%11111110,%00000000
       dta %00000000,%01111100,%11111110,%11111110,%00000000
       dta %00000000,%01111100,%11111110,%11111110,%00000000
       dta %00000000,%01111100,%01111100,%01111100,%00000000
       dta %00000000,%01111100,%01111100,%01111100,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000

napis_WIN
       dta %00000000,%11101110,%01111100,%11100110,%01111100
       dta %00000000,%11101110,%01111100,%11100110,%01111100
       dta %00000000,%11101110,%01111100,%11110110,%01111100
       dta %00000000,%11101110,%01111100,%11110110,%01111100
       dta %00000000,%11101110,%01111100,%11111110,%01111100
       dta %00000000,%11101110,%01111100,%11111110,%01111100
       dta %00000000,%11111110,%01111100,%11111110,%00111000
       dta %00000000,%11111110,%01111100,%11111110,%00111000
       dta %00000000,%11111110,%01111100,%11111110,%00000000
       dta %00000000,%11111110,%01111100,%11111110,%00000000
       dta %00000000,%11101110,%01111100,%11101110,%00111000
       dta %00000000,%11101110,%01111100,%11101110,%00111000
       dta %00000000,%11000110,%01111100,%11101110,%00111000
       dta %00000000,%11000110,%01111100,%11101110,%00111000
       dta %00000000,%00000000,%00000000,%00000000,%00000000
       dta %00000000,%00000000,%00000000,%00000000,%00000000


       org $3400
;--cyfry - musza byc od pelnej strony!
napis_0
       dta %01111100
       dta %01111100
       dta %11101110
       dta %11101110
       dta %11101110
       dta %11101110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000
napis_1
       dta %00111000
       dta %00111000
       dta %11111000
       dta %11111000
       dta %00111000
       dta %00111000
       dta %00111000
       dta %00111000
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %00000000
       dta %00000000

napis_2
       dta %01111100
       dta %01111100
       dta %11000110
       dta %11000110
       dta %00011100
       dta %00011100
       dta %01110000
       dta %01110000
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %00000000
       dta %00000000

napis_3
       dta %11111110
       dta %11111110
       dta %00011100
       dta %00011100
       dta %01111000
       dta %01111000
       dta %00011100
       dta %00011100
       dta %11011110
       dta %11011110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000

napis_4
       dta %00011100
       dta %00011100
       dta %11011100
       dta %11011100
       dta %11011100
       dta %11011100
       dta %11011100
       dta %11011100
       dta %11111110
       dta %11111110
       dta %00011100
       dta %00011100
       dta %00011100
       dta %00011100
       dta %00000000
       dta %00000000

napis_5
       dta %11111110
       dta %11111110
       dta %11100000
       dta %11100000
       dta %11111100
       dta %11111100
       dta %00001110
       dta %00001110
       dta %11101110
       dta %11101110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000

napis_6
       dta %01111110
       dta %01111110
       dta %11100000
       dta %11100000
       dta %11111100
       dta %11111100
       dta %11101110
       dta %11101110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000

napis_7
       dta %11111110
       dta %11111110
       dta %00001110
       dta %00001110
       dta %00001110
       dta %00001110
       dta %00011100
       dta %00011100
       dta %00111000
       dta %00111000
       dta %01110000
       dta %01110000
       dta %01110000
       dta %01110000
       dta %00000000
       dta %00000000

napis_8
       dta %01111100
       dta %01111100
       dta %11101110
       dta %11101110
       dta %01111100
       dta %01111100
       dta %11101110
       dta %11101110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000

napis_9
       dta %01111100
       dta %01111100
       dta %11101110
       dta %11101110
       dta %01111110
       dta %01111110
       dta %00001110
       dta %00001110
       dta %11101110
       dta %11101110
       dta %11111110
       dta %11111110
       dta %01111100
       dta %01111100
       dta %00000000
       dta %00000000

napis_spacja
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000
       dta %00000000

;----------------------------------------
;display list
dl
         dta $70,$70,$70
         dta $44,a(pamiec_ekranu)
:3       dta $04
         dta $04+$80
:6       dta $04
         dta $04+$80
:4       dta $04
:6       dta $04+$80
:2       dta $04
;         dta $02
         dta $41,a(dl)

;---------------------------------------
;---------------------------------------
start
     jsr inicjalizacja_gry
st_1
     jsr inicjalizajca_rozgrywki

     jsr ustaw_i_wlacz_przerwania

;--------------------------------------------------
;--------------------------------------------------
;tu sie zaczyna glowna petla w czasie gry
g2
     lda licznik       ;synchronizacja z VBI
     cmp licznik_old
     beq g2
     sta licznik_old

     ;co 1 ramke
     JSR  REPLAY+6    ;Play...

     ;co 8 ramek
     ;(ale na innej ramce niz obsluga licznika klocka)
     lda licznik
     and #%00000111
     cmp #2
     bne g13
     ;obsluga licznika punktow
     lda punkty_bufor
     bne g13a
     lda punkty_bufor+1
     beq g13
g13a
     ;jest cos do doliczenia
     lda punkty_bufor+1
     bne g13d   ;jak starszy <> 0 to bufor na pewno >101
g13b
     ;starszy  = 00
     lda punkty_bufor
     cmp #12
     bcs g13c
     ;punkty_bufor < 12
     lda #1
     jsr obsluz_punkty
     jmp g13e
g13c
     cmp #101
     bcs g13d
     ;10 <= punkty_bufor < 101
     lda #10
     jsr obsluz_punkty
     jmp g13e
g13d
     ;punkty_bufor >= 101
     lda #100
     jsr obsluz_punkty
g13e
     jsr punkty2pmg   ;wyswietla punkty na duszkach
g13
     ;co 8 ramek
     lda licznik
     and #%00000111
     cmp #1
     bne g10
     ;--obsluga licznika klocka
     inc licznik_klocka
     jsr rysuj_licznik_klocka
     lda licznik_klocka
     cmp #max_licznik_klocka
     bne g10
     ;licznik_klocka osiagnal max
     lda #0
     sta licznik_klocka
     ;dzielenie licznika czasu /2
     lsr licznik_czasu+1
     ror licznik_czasu
     lda #10
     sta przesun_czas
     ;odtworzenie ekranu spod klocka - konieczne
     mwa klocek_adr _arr
     jsr odtworz_z_bufora
     jmp g8a  ;tam jest dalsza obsluga
g10
     ;co 4 ramke na reszcie 3
     ;obsluga wahniecia licznika czasu
     lda licznik
     and #%00000011
     cmp #3
     beq g10d
     lda przesun_czas
     beq g10d
     and #1
     beq g10e
     ;dodajemy
     clc
     lda #pozycja_X_P0
     adc przesun_czas
     sta uni2
     jmp g10f
g10e
     ;odejmujemy
     lda #pozycja_X_P0
     sec
     sbc przesun_czas
     sta uni2
g10f
     clc
     lda uni2
     sta HPOSM3
     adc #2
     sta HPOSM2
     adc #2
     sta HPOSM1
     adc #2
     sta HPOSM0
     adc #2
     sta HPOSP0
     adc #8
     sta HPOSP1
     adc #8
     sta HPOSP2
     adc #8
     sta HPOSP3
     dec przesun_czas
g10d
     ;reszta co 4 ramke na reszcie 0
     lda licznik
     and #%00000011
     beq g10a
     jmp g7
g10a
     ;--obsluga licznika czasu
     lda licznik_czasu   ;16-bitowo w dol do 0
     bne g10b
     lda licznik_czasu+1
     bne g10b
     ;---czas sie skonczyl! PRZEGRANA---
     lda #1
     jsr obsluz_przegrana_wygrana ;wroci po nacisnieciu spacji
     ;wychodzimy z petli
     jmp st_1 ;do nowej gry
g10b
     ;zmniejszenie licznika czasu
     dec licznik_czasu
     lda licznik_czasu
     cmp #$FF
     bne g10c
     dec licznik_czasu+1
g10c
     jsr licznik_czasu2pmg
     ;--czy jestesmy w fazie mrugania liniami
     lda #0
     sta czy_mrug_poziom    ;wskaznik czy po obsludze pionowych skoczyc na koniec czy przejsc do obslugi joya
     lda mrugaj_liniami_poziomymi
     beq g2b
     inc czy_mrug_poziom
     lda licznik
     and #%00000111  ;co 8 ramke
     beq g12
     jmp g7
g12
     lda mrugaj_liniami_poziomymi
     and #%00000001
     beq g2d
     lda #17
     jmp g2e
g2d
     lda #1
g2e
     jsr mrugnij_liniami_poziomymi
     dec mrugaj_liniami_poziomymi
     bne g2b
     ;juz zamrugalismy, teraz przesuwanie linii poziomych
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr odtworz_z_bufora
     jsr przesun_linie_poziome
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr do_bufora_pod_klockiem
     jsr czy_wygralismy
     bne g2b
     ;--WYGRANA!--
     lda #0
     jsr obsluz_przegrana_wygrana ;wroci po nacisnieciu spacji
     ;wychodzimy z petli
     jmp st_1 ;do nowej gry
;--ewentualne mruganie pionowymi
g2b
     lda mrugaj_liniami_pionowymi
     beq g2c
     lda licznik
     and #%00000111  ;co 8 ramke
     beq g11
     jmp g7
g11
     lda mrugaj_liniami_pionowymi
     and #%00000001
     beq g2g
     lda #17
     jmp g2h
g2g
     lda #1
g2h
     jsr mrugnij_liniami_pionowymi
     dec mrugaj_liniami_pionowymi
     bne g2i
     ;juz zamrugalismy, teraz przesuwanie linii pionowych
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr odtworz_z_bufora
     jsr przesun_linie_pionowe
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr do_bufora_pod_klockiem
     jsr czy_wygralismy
     bne g2b
     ;--WYGRANA!--
     lda #0
     jsr obsluz_przegrana_wygrana ;wroci po nacisnieciu spacji
     ;wychodzimy z petli
     jmp st_1 ;do nowej gry
g2i
     jmp g7 ;koniec
g2c
     lda czy_mrug_poziom
     bne g2i
     ;-----czy ESC wcisniety - wyjscie do DOS
     lda 764
     cmp #$1C
     bne g2cc
     ;--wyjscie do DOSa
     mva #$00 GRACTL            ;zatrzymanie wyswietlania PMG
     ;wylaczenie muzyki
     LDA  #$40
     JSR  REPLAY+3
     ;wylaczenie przerwan
     lda #0
     sta NMIEN
     ;przywrocenie czcionek systemowych
     lda #$E0
     sta CHBAS
     jmp ($000a)          ;wyjscie do DOS
g2cc
     ;--czy spacja wcisnieta - obrot
     lda 764
     cmp #$21
     bne g2j
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr odtworz_z_bufora
     jsr obroc_klocek
     mwa klocek_adr _arr       ;zabezpieczenie
     jsr do_bufora_pod_klockiem
     lda #$ff    ; ustawiamy na $FF ostatnio wcisniety klawisz
     sta 764
g2j
     ;--czy fire wcisniety
     lda fire
     and #1
     bne g2aa
     ;--fire wcisniety
     lda byl_fire_wycisniety  ;czy po poprzednim wcisnieciu zostal zwolniony
     bne g2a
     lda #1
     sta byl_fire_wycisniety
     ;--
     inc fire_licznik
     lda fire_licznik
     cmp #do_ilu_fire
     bne g2a
     ;fire wcisniety dostatecznie dlugo
     lda #0
     sta fire_licznik
     lda czy_mozna_postawic
     beq g2a
     ;stawiamy klocek
     mwa klocek_adr _arr
     ldx #1         ;znak dla stawianego klocka
     lda klocek
     jsr wyswietl_klocek
     ;sprawdzenie czy sa linie do skasowania
     jsr sprawdz_linie
     ;resetujemy licznik_klocka
     lda #0
     sta licznik_klocka
     ;nastepny klocek staje sie obecnym
g8a
     lda klocek_next
     sta klocek
     ;sprawdzanie czy pozycja klocka nie musi zostac poprawiona
     jsr popraw_pozycje_klocka
     ;zeby nam nie nadpisalo postawionego klocka przy nastepnym obrocie petli
     mwa klocek_adr _arr
     jsr do_bufora_pod_klockiem
     ;losowanie nastepnego klocka
     jsr losuj_klocek
     sta klocek_next
     ;rysowanie nastepnego klocka
     jsr zeruj_miejsce_na_next_klocek
     mwa #gdzie_rys_next_klocek _arr
     ldx #5         ;znak dla stawianego klocka
     lda klocek_next
     jsr wyswietl_klocek
     jmp g7 ;koniec
g2aa
     lda #0             ;oznaczenie ze fire nie wcisniety
     sta fire_licznik
     sta byl_fire_wycisniety
g2a
     ;-----ruch klockiem-------------
     mwa klocek_adr _arr
     jsr odtworz_z_bufora   ;zamazanie klocka
     ;gora
     lda stan_joya
     and #1
     bne g3
     lda klocek_Y
     beq g6  ;jak jest 0 to wyzej juz sie nie da
     ;przesuwamy w gore
     dec klocek_Y
     dec klocek_Y
     lda klocek_adr
     sec
     sbc #80
     sta klocek_adr
     lda klocek_adr+1
     sbc #0
     sta klocek_adr+1
     jmp g6
g3
     ;dol
     lda stan_joya
     and #2
     bne g4
     lda klocek
     asl @
     tay
     lda klocek_Y
     cmp granice_przesuwania+1,y
     beq g6  ;jak jestesmy najnizej to juz nizej sie nie da
     ;przesuwamy w dol
     inc klocek_Y
     inc klocek_Y
     lda klocek_adr
     clc
     adc #80
     sta klocek_adr
     lda klocek_adr+1
     adc #0
     sta klocek_adr+1
     jmp g6
g4
     ;lewo
     lda stan_joya
     and #4
     bne g5
     lda klocek_X
     beq g6  ;jak jest 0 to wyzej juz sie nie da
     ;przesuwamy w lewo
     dec klocek_X
     dec klocek_X
     lda klocek_adr
     sec
     sbc #2
     sta klocek_adr
     lda klocek_adr+1
     sbc #0
     sta klocek_adr+1
     jmp g6
g5
     ;prawo
     lda stan_joya
     and #8
     bne g6
     lda klocek
     asl @
     tay
     lda klocek_X
     cmp granice_przesuwania,y
     beq g6  ;jak jestesmy najdalej w prawo to juz dalej sie nie da
     ;przesuwamy w prawo
     inc klocek_X
     inc klocek_X
     lda klocek_adr
     clc
     adc #2
     sta klocek_adr
     lda klocek_adr+1
     adc #0
     sta klocek_adr+1
g6
     mwa klocek_adr _arr
     ;przelozenie bajtow z ekranu do bufora
     jsr do_bufora_pod_klockiem
     mwa klocek_adr _arr
     ldx #5
     lda klocek
     jsr wyswietl_klocek
g7
     jmp g2


;--------------------------
;obraca klocek i przesuwa jesli po obrocie wystaje poza granice
;uzywa: Y
obroc_klocek
     ldy klocek
     lda kolejnosc_obrotow_tab,y
     sta klocek
     jsr popraw_pozycje_klocka
     rts


;---------------------------
;jesli klocek wystaje poza pole gry to go przesuwa
;korzysta z: Y, uni2, uni3
popraw_pozycje_klocka
     lda klocek
     asl @
     tay
     lda o_ile_przesunac,y
     clc
     adc klocek_X
     bpl ppk1
     lda #0
ppk1
     sta klocek_X
     lda o_ile_przesunac+1,y
     clc
     adc klocek_Y
     bpl ppk2
     lda #0
ppk2
     sta klocek_Y
     ;--
     lda granice_przesuwania,y
     sta uni2                 ;max pozycja X
     lda granice_przesuwania+1,y
     sta uni3                 ;max pozycja Y
     lda klocek_X
     cmp uni2
     bcc ppk8
     lda uni2  ;korekta pozycji X
     sta klocek_X
ppk8
     lda klocek_Y
     cmp uni3
     bcc ppk9
     lda uni3  ;korekta pozycji y
     sta klocek_y
ppk9
     jsr XY_2_klocek_adr
     rts

;--------------------------
;narzedziowka
;dodaje A do punktow (3B) i odejmuje od bufora (2B)
obsluz_punkty
     sta op_1+1 
     clc
     adc punkty
     sta punkty
     lda #0
     adc punkty+1
     sta punkty+1
     lda #0
     adc punkty+2
     sta punkty+2
     ;odejmowanie
     lda punkty_bufor
     sec
op_1
     sbc #0 ;automodyfikowany
     sta punkty_bufor
     lda punkty_bufor+1
     sbc #0
     sta punkty_bufor+1
     rts

;-------------------------------
;na podstawie:
;tabela_odpowiedzi_linii_poziom
;tabela_odpowiedzi_linii_pion
;doklada punkty do bufora
;przyjmuje, ze na pewno jest choc 1 linia
;max jest mozliwe 5 linii zniknietych
;uzywa: X,Y,_arr
dolicz_punkty_do_bufora
     ;--ile linii
     ldx #0      ;zerowanie licznika
     ;--najpierw poziom
     ldy #12
dpdb_1
     lda tabela_odpowiedzi_linii_poziom,y
     cmp #$FF
     beq dpdb_2
     inx
dpdb_2
     dey
     dey
     dey
     dey
     bpl dpdb_1
     ;--teraz pion
     ldy #3
dpdbzp_1
     lda tabela_odpowiedzi_linii_pion,y
     cmp #$FF
     beq dpdbzp_2
     inx
dpdbzp_2
     dey
     bpl dpdbzp_1
     ;teraz punkty zaleznie od liczby linii
     dex
     txa
     asl @
     tax
     lda dpdb_punktacja,x
     sta _arr
     lda dpdb_punktacja+1,x
     sta _arr+1
     ;dodajemy punkty do bufora
     lda _arr
     clc
     adc punkty_bufor
     sta punkty_bufor
     lda _arr+1
     adc punkty_bufor+1
     sta punkty_bufor+1
     rts
dpdb_punktacja
     dta a($0064),a($0190),a($0384),a($0640),a($0DAC)


;-------------------------------
;rysuje pionowy slupek
rysuj_licznik_klocka
     ;rysowanie kreski rozpoczynajacej
     ldy #max_licznik_klocka+1
     lda #$FF
     sta gdzie_rys_licznik_klocka,y
     dey
     ;rysowanie pelnych kresek
     ldx licznik_klocka
     beq rlk_2
     lda #$FF ;#%10000001
rlk_1
     sta gdzie_rys_licznik_klocka,y
     dey
     dex
     bne rlk_1
rlk_2
     ;rysowanie pustych kresek
     lda #max_licznik_klocka
     sec
     sbc licznik_klocka
     tax
     beq rlk_3
     lda #%10000001
rlk_4
     sta gdzie_rys_licznik_klocka,y
     dey
     dex
     bne rlk_4
rlk_3
     ;rysowanie kreski konczacej
     lda #$FF
     sta gdzie_rys_licznik_klocka,y
     rts

;-------------------------------
;rysuje linie poziome umieszczone w tabela_odpowiedzi_linii_poziom
;znakami w A
mrugnij_liniami_poziomymi
     sta mlp_5+1         ;ustawienie znaku do rysowania
     ldx #0
mlp_1
     lda tabela_odpowiedzi_linii_poziom,x
     cmp #$FF
     beq mlp_2                   ;jak $FF to juz dalej nie trzeba sprawdzac
     lda tabela_odpowiedzi_linii_poziom+1,x
     sta _arr
     lda tabela_odpowiedzi_linii_poziom+2,x
     sta _arr+1                     ;w _arr mamy adres pierwszego znaku w linii do wypelnienia
     lda #12
     sta uni2
mlp_5
     lda #0  ;automodyfikowany
     jsr rysuj_kwadrat
     lda #2
     jsr dodaj_A_do_arr
     dec uni2
     bne mlp_5
     inx
     inx
     inx
     inx
     cpx #16
     bne mlp_1
mlp_2
     rts

;-------------------------------
;rysuje linie pionowe umieszczone w tabela_odpowiedzi_linii_pion
;znakami w A
;uzywa: _arr2, _arr, uni2, x, y (w podproceurze)
mrugnij_liniami_pionowymi
     sta uni2         ;ustawienie znaku do rysowania
     mwa #pamiec_ekranu _arr2
     ldx #12
mlpi_1
     ;1 mozliwa linia
     lda tabela_odpowiedzi_linii_pion
     cmp #$FF
     beq mlpi_3                   ;jak $FF to nastepny kwadrat
     clc
     adc _arr2
     sta _arr
     lda #0
     adc _arr2+1
     sta _arr+1
     lda uni2
     jsr rysuj_kwadrat
     ;2 mozliwa linia
mlpi_3
     lda tabela_odpowiedzi_linii_pion+1
     cmp #$FF
     beq mlpi_4                   ;jak $FF to nastepny kwadrat
     clc
     adc _arr2
     sta _arr
     lda #0
     adc _arr2+1
     sta _arr+1
     lda uni2
     jsr rysuj_kwadrat
     ;3 mozliwa linia
mlpi_4
     lda tabela_odpowiedzi_linii_pion+2
     cmp #$FF
     beq mlpi_5                   ;jak $FF to nastepny kwadrat
     clc
     adc _arr2
     sta _arr
     lda #0
     adc _arr2+1
     sta _arr+1
     lda uni2
     jsr rysuj_kwadrat
     ;4 mozliwa linia
mlpi_5
     lda tabela_odpowiedzi_linii_pion+3
     cmp #$FF
     beq mlpi_6                   ;jak $FF to nastepny kwadrat
     clc
     adc _arr2
     sta _arr
     lda #0
     adc _arr2+1
     sta _arr+1
     lda uni2
     jsr rysuj_kwadrat
mlpi_6
     ;dodajemy 80 do adresu poczatku linii
     lda _arr2
     clc
     adc #80
     sta _arr2
     lda _arr2+1
     adc #0
     sta _arr2+1
     dex
     bne mlpi_1
     rts


;-------------------------------
;przesuwa linie poziome umieszczone w tabela_odpowiedzi_linii
;zachowuje odpowiednia kolejnosc przesuwania:
;od zewnatrz do srodka planszy
przesun_linie_poziome
     ldx #0
plp_1
     lda tabela_odpowiedzi_linii_poziom,x
     cmp #$FF
     bne plp_1a
     jmp plp_21
plp_1a
     cmp #12  ;w tej czesci obslugujemy tylko od linii 0 do 11
     bcs plp_3 ;jak linia >= 12 to skocz
     cmp #0      ;jak najmlodsza linia to nie przepisujemy
     beq plp_8b  ;tylko wypelniamy zerami
     lda tabela_odpowiedzi_linii_poziom+1,x
     sec
     sbc #40
     sta _arr
     lda tabela_odpowiedzi_linii_poziom+2,x
     sbc #0
     sta _arr+1                   ;mamy adres poczatku linii z ktorej mamy przesuwac
     lda tabela_odpowiedzi_linii_poziom+1,x
     clc
     adc #40
     sta _arr2
     lda tabela_odpowiedzi_linii_poziom+2,x
     adc #0
     sta _arr2+1                  ;i adres poczatku linii gdzie bedziemy przesuwac
     ;teraz petla przepisujaca
plp_4
     ldy #23
plp_5
     lda (_arr),y
     sta (_arr2),y
     dey
     bpl plp_5
     ;sprawdzamy czy to koniec
     lda _arr
     cmp #<pamiec_ekranu
     bne plp_6
     lda _arr+1
     cmp #>pamiec_ekranu
     bne plp_6
     ;koniec przepisywania
     ;pierwsze dwie linie wypelniamy zerami
plp_8b
     ldy #23
plp_8
     lda #0
     sta pamiec_ekranu,y
     dey
     bpl plp_8
     ldy #23
plp_8a
     lda #0
     sta pamiec_ekranu+40,y
     dey
     bpl plp_8a
     jmp plp_7
plp_6
     ;odejmujemy 40 od _arr
     lda _arr
     sec
     sbc #40
     sta _arr
     lda _arr+1
     sbc #0
     sta _arr+1
     ;odejmujemy 40 od _arr2
     lda _arr2
     sec
     sbc #40
     sta _arr2
     lda _arr2+1
     sbc #0
     sta _arr2+1
     jmp plp_4
plp_7
     inx
     inx
     inx
     inx
     cpx #16
     beq plp_21 ;!!!plp_3 zmiana 2011-05-24
     jmp plp_1
plp_3
     ;-------------tu obslugujemy linie od 12 do 23---------------
     ldx #12
plp_11
     lda tabela_odpowiedzi_linii_poziom,x
     cmp #$FF
     beq plp_71
     cmp #12  ;w tej czesci nie obslugujemy linii 0 do 11
     bcc plp_21 ;jak linia < 12 to skocz
     cmp #22      ;jak ostatnia linia to nie przepisujemy
     beq plp_8b1  ;tylko wypelniamy zerami
     lda tabela_odpowiedzi_linii_poziom+1,x
     sta _arr2
     lda tabela_odpowiedzi_linii_poziom+2,x
     sta _arr2+1                   ;mamy adres poczatku gdzie bedziemy przesuwac
     lda tabela_odpowiedzi_linii_poziom+1,x
     clc
     adc #80
     sta _arr
     lda tabela_odpowiedzi_linii_poziom+2,x
     adc #0
     sta _arr+1                  ;i adres poczatku linii z ktorej bedziemy przesuwac
     ;teraz petla przepisujaca
plp_41
     ldy #23
plp_51
     lda (_arr),y
     sta (_arr2),y
     dey
     bpl plp_51
     ;sprawdzamy czy to koniec
     lda _arr
     cmp #<[pamiec_ekranu+23*40]
     bne plp_61
     lda _arr+1
     cmp #>[pamiec_ekranu+23*40]
     bne plp_61
     ;koniec przepisywania
     ;ostatnie dwie linie wypelniamy zerami
plp_8b1
     ldy #23
plp_81
     lda #0
     sta pamiec_ekranu+22*40,y
     dey
     bpl plp_81
     ldy #23
plp_8a1
     lda #0
     sta pamiec_ekranu+23*40,y
     dey
     bpl plp_8a1
     jmp plp_71
plp_61
     ;dodajemy 40 do _arr
     lda _arr
     clc
     adc #40
     sta _arr
     lda _arr+1
     adc #0
     sta _arr+1
     ;dodajemy 40 do _arr2
     lda _arr2
     clc
     adc #40
     sta _arr2
     lda _arr2+1
     adc #0
     sta _arr2+1
     jmp plp_41
plp_71
     dex
     dex
     dex
     dex
     bpl plp_11
plp_21
     rts



;-------------------------------
;przesuwa linie poziome umieszczone w tabela_odpowiedzi_linii_pion
;zachowuje odpowiednia kolejnosc przesuwania:
;od zewnatrz do srodka planszy
;uzywa uni2, _arr
przesun_linie_pionowe
     ldx #0
     stx kolumna_pion
plpi_1
     lda tabela_odpowiedzi_linii_pion,x
     sta uni2
     cmp #$FF
     bne plpi_1a
     jmp plpi_61
plpi_1a
     cmp #12  ;w tej czesci obslugujemy tylko od linii 0 do 11
     bcs plpi_6 ;jak linia >= 12 to skocz
     ;------przesuwamy linie w prawo------
     mwx #pamiec_ekranu _arr
     ldx #24    ;24 kolejne rzedy
plpi_5e
     ldy uni2
     cpy #0
     beq plpi_5d
plpi_5
     dey ;zaczynamy przepisywanie od kolumny o 1 znak nizszej
plpi_5a
     lda (_arr),y
     iny
     iny
     sta (_arr),y
     dey
     dey
     beq plpi_5d
     jmp plpi_5
plpi_5d
     ;wpisanie 0 do kolumn 1 i 0
     lda #0
     ldy #0
     sta (_arr),y
     iny
     sta (_arr),y
     ;--dodajemy 40 do adresu poczatku linii
     lda #40
     jsr dodaj_A_do_arr
     ;--
     dex
     bne plpi_5e
     ;--
     inc kolumna_pion
     ldx kolumna_pion
     cpx #4
     beq plpi_61
     jmp plpi_1
plpi_6
     ;-------------tu obslugujemy linie od 12 do 23---------------
     ldx #3
     stx kolumna_pion
plpi_11
     lda tabela_odpowiedzi_linii_pion,x
     sta uni2
     cmp #$FF
     beq plpi_5f1
plpi_1a1
     cmp #12  ;w tej czesci nie obslugujemy linii 0 do 11
     bcc plpi_61 ;jak linia < 12 to skocz na koniec
     ;------przesuwamy linie w lewo------
     mwx #pamiec_ekranu _arr
     ldx #24    ;24 kolejne rzedy
plpi_5e1
     ldy uni2
     cpy #22        ;jak ostatnia linia to nie przepisujemy
     beq plpi_5d1
     iny ;zaczynamy przepisywanie od kolumny o 2 znaki wyzszej
plpi_51
     iny
plpi_5a1
     lda (_arr),y
     dey
     dey
     sta (_arr),y
     iny
     iny
     cpy #23
     beq plpi_5d1
     jmp plpi_51
plpi_5d1
     ;wpisanie 0 do kolumn 22 i 23
     lda #0
     ldy #22
     sta (_arr),y
     iny
     sta (_arr),y
     ;--dodajemy 40 do adresu poczatku linii
     lda #40
     jsr dodaj_A_do_arr
     ;--
     dex
     bne plpi_5e1
     ;--
plpi_5f1
     dec kolumna_pion
     ldx kolumna_pion
     cpx #255
     bne plpi_11
plpi_61
     rts





;-------------------------------
;sprawdza czy po postawieniu klocka sa jakies pelne linie
;w jedym ruchu moga zniknac max 4 linie w poziomie i 4 w pionie
sprawdz_linie
     jsr FF_tabele_odpowiedzi_linii ;czyscimy obie tabele odpowiedzi
     ;zerujemy automodyfikowany wskaznik czy znalazl linie
     lda #0
     sta sl_3+1
     ;ustawiamy adres poczatku linii w _arr
     lda klocek_adr
     sec
     sbc klocek_X
     sta _arr
     lda klocek_adr+1
     sbc #0
     sta _arr+1
     ;buforujemy pozycje Y
     lda klocek_Y
     sta uni2
     ;sprawdzamy linie poziome - 4, zaczynajac od klocek_Y
     lda #0
     sta wskaz_tabela_odpowiedzi_linii
     ldy #4
sl_1
     sty sl_2+1
     jsr sprawdz_linie_pozioma
sl_2
     ldy #0    ;automodyfikowany
     dey
     bne sl_1
     ;sprawdzamy czy wykryto choc jedna linie pelna
     lda wskaz_tabela_odpowiedzi_linii
     beq sl_4a
     sta sl_3+1
     ;obsluga wykrytych pelnych linii poziomych
     lda #ile_razy_mrugnac_linia
     sta mrugaj_liniami_poziomymi
sl_4a
     ;buforujemy pozycje X
     lda klocek_X
     sta uni2
     ;sprawdzamy linie pionowe - 4 zaczynajac od klocek_X
     lda #0
     sta wskaz_tabela_odpowiedzi_linii
     ldy #4
sl_4
     sty sl_5+1
     jsr sprawdz_linie_pionowa
sl_5
     ldy #0    ;automodyfikowany
     dey
     bne sl_4
     ;sprawdzamy czy wykryto choc jedna linie pelna
     lda wskaz_tabela_odpowiedzi_linii
     beq sl_3
     sta sl_3+1
     ;obsluga wykrytych pelnych linii pionowych
     lda #ile_razy_mrugnac_linia
     sta mrugaj_liniami_pionowymi
sl_3
     ;--czy doliczamy jakies punkty
     lda #0 ;automodyfikowany
     beq sl_6
     jsr dolicz_punkty_do_bufora
sl_6
     rts

;----------------------------------
;sprawdza linie pozioma zaczynajac od adresu _arr
;adres w _arr sie zmienia
;uzywa: Y, _arr
sprawdz_linie_pozioma
     ldy #22
slpz_1
     lda (_arr),y
     cmp #1
     bne slpz_2 ;jak choc jedna zla to cala linia zla
     dey
     dey
     bpl slpz_1
     ;wiemy ze cala linia dobra
     ;zapisujemy do tabeli odpowiedzi
     ldy wskaz_tabela_odpowiedzi_linii
     lda uni2   ;tu mamy pozycje Y
     sta tabela_odpowiedzi_linii_poziom,y
     iny
     lda _arr
     sta tabela_odpowiedzi_linii_poziom,y
     iny
     lda _arr+1
     sta tabela_odpowiedzi_linii_poziom,y
     iny
     iny ;teraz y wskazuje na nastepny wolny rzad w tabeli odpowiedzi
     sty wskaz_tabela_odpowiedzi_linii
slpz_2
     inc uni2  ;od razu wskazujemy na kolejna linie
     inc uni2
     lda #80
     jsr dodaj_A_do_arr
     rts


;----------------------------------
;sprawdza linie pionowa uni2
;uzywa: Y, _arr
sprawdz_linie_pionowa
     ldy uni2 ;pozycja linii pionowej
     ldx #44  ;2x22 (od ostatniej linii klockow)
slpi_1
     lda wskazy_linii_obr,x
     sta _arr
     lda wskazy_linii_obr+1,x
     sta _arr+1
     lda (_arr),y
     cmp #1
     bne slpi_2 ;jak choc jedna zla to cala linia zla
     dex
     dex
     dex
     dex
     bpl slpi_1
     ;wiemy ze cala linia dobra
     ;zapisujemy do tabeli odpowiedzi
     ldy wskaz_tabela_odpowiedzi_linii
     lda uni2   ;tu mamy pozycje Y
     sta tabela_odpowiedzi_linii_pion,y
     iny ;teraz y wskazuje na nastepny wolny znak w tabeli odpowiedzi
     sty wskaz_tabela_odpowiedzi_linii
slpi_2
     inc uni2  ;od razu wskazujemy na kolejna linie
     inc uni2
     rts


;---------------------
;narzedziowka
;dodaje A do _arr
;nic nie zmienia
dodaj_A_do_arr
     sta dAda_1+1 ;zeby nie zmienic A w procedurze
     clc
     adc _arr
     sta _arr
     lda #0
     adc _arr+1
     sta _arr+1
dAda_1
     lda #0 ;automodyfikowany
     rts


;----inicjalizacja PMG----
inicjalizacja_PMG
     lda #>pmg_memory_1
     sta PMBASE
     ;DMACTL = playfield + dl + players + missiles + hires_sprites
     lda #62
     sta DMACTL
     ;GRACTL = players + missiles
     lda #3
     sta GRACTL
     ;GPRIOR  = 1
     lda #%00000001 ;priorytet 1
     sta GPRIOR
     ;pojedyncza szerokosc gracza 0
     lda #0
     sta SIZEP0
     sta SIZEP1
     sta SIZEP2
     sta SIZEP3
     ;-----koniec inicjalizacji PMG----
     rts

;-------------------------------
;oblicza klocek_adr na podstawie klocek_X,klocek_Y
XY_2_klocek_adr
     mwa #pamiec_ekranu klocek_adr
     ldy klocek_Y
     beq xy2ka_2
xy2ka_1
     lda #40
     clc
     adc klocek_adr
     sta klocek_adr
     lda #0
     adc klocek_adr+1
     sta klocek_adr+1
     dey
     bne xy2ka_1
xy2ka_2
     lda klocek_X
     clc
     adc klocek_adr
     sta klocek_adr
     lda #0
     adc klocek_adr+1
     sta klocek_adr+1
     rts

;-------------------------------------
;narzedziowka czyszczaca obszar 4x8 znakow
;pod nastepny klocek
zeruj_miejsce_na_next_klocek
     mwa #gdzie_rys_next_klocek _arr
     ldx #8
zmnnk_2
     ldy #3
zmnnk_1
     lda #czym_wypelniac_panel
     sta (_arr),y
     dey
     bpl zmnnk_1
     lda #40
     clc
     adc _arr
     sta _arr
     lda #0
     adc _arr+1
     sta _arr+1
     dex
     bne zmnnk_2
     rts

;-------------------------------------
;wypelnia obszar panelu fontem
wypelnij_panel
     mwa #pamiec_ekranu+24 _arr
     ldx #24
wp_2
     ldy #15
wp_1
     lda #czym_wypelniac_panel
     sta (_arr),y
     dey
     bpl wp_1
     lda #40
     clc
     adc _arr
     sta _arr
     lda #0
     adc _arr+1
     sta _arr+1
     dex
     bne wp_2
     rts


;----------------------------------------------------
;wyswietla klocek o numerze w A
;na pozycji _arr
;uzywajac znaku od X
;uzywa: X, Y, A, _arr, uni2, uni4
wyswietl_klocek
     stx wk_6a+1   ;od ktorego znaku zaczac wyswietlanie kwadratow
     ;rysujemy klocek
     asl @
     asl @    ;x4
     tax
     lda #4
     sta uni2
     lda #1
     sta czy_mozna_postawic  ;domyslnie mozna postawic klocek
wk_6
     lda klocki_tab,x
     sta klocek_roboczy
     lda #4
     sta uni4  ;licznik bitow
wk_7     
     lda klocek_roboczy
     asl @
     sta klocek_roboczy
     bcc wk_2
     ;jesli stawiamy klocek od znaku 1 to nie sprawdzamy czy mozna postawic i czy na czerowono
     lda wk_6a+1
     cmp #1
     beq wk_6b
     ;sprawdzamy czy kwadrat lezy na innym
     ;jesli tak to rysujemy w 5 kolorze
     ldy #0
     lda (_arr),y
     beq wk_6b
     lda wk_6a+1
     ora #%10000000    ;ustawienie 7 bitu znaku
     sta wk_6a+1
     lda #0
     sta czy_mozna_postawic  ;jak choc jeden nachodzi to nie mozna postawic klocka
     jmp wk_6a
wk_6b
     lda wk_6a+1
     and #%01111111    ;wyzerowanie 7 bitu znaku
     sta wk_6a+1
wk_6a
     lda #0   ;automodyfikowany
     jsr rysuj_kwadrat
wk_2
     dec uni4
     lda uni4
     beq wk_8
     lda #2
     jsr dodaj_do_arr
     jmp wk_7
wk_8
     inx
     dec uni2
     lda uni2
     beq wk_3   ;koniec
     lda #74
     jsr dodaj_do_arr
     jmp wk_6
wk_3
     rts


;narzedziowka - dodaje A do _arr
dodaj_do_arr
     clc
     adc _arr
     sta _arr
     lda #0
     adc _arr+1
     sta _arr+1
     rts

;--------------------------------------
;rysuje kwadrat zaczynajac od fontu w A
;od adresu _arr
;uzywa: Y, uni3
rysuj_kwadrat
     sta uni3
     ldy #0
     sta (_arr),y
     inc uni3
     iny
     lda uni3
     sta (_arr),y
     inc uni3
     tya
     clc
     adc #39
     tay
     lda uni3
     sta (_arr),y
     inc uni3
     iny
     lda uni3
     sta (_arr),y
     rts

;---------------------------------------------------------
;kopiuje 64 bajty (8x8) z pamieci ekranu od _arr do bufora
;czyli zachowuje w pamieci znaki na ktorych ma byc klocek
do_bufora_pod_klockiem
     mwa _arr dbpk_2+1 ;wstawienie adresu
     lda #8
     sta uni2
     ldx #0
dbpk_1
     ldy #7       ;8 znakow
dbpk_2
     lda $FFFF,y      ;automodyfikowalny
     sta bufor_pod_klockiem,x
     inx
     dey
     bpl dbpk_2
     ;dodaj 40 do adresu
     lda #40
     clc
     adc dbpk_2+1
     sta dbpk_2+1
     lda #0
     adc dbpk_2+2
     sta dbpk_2+2
     dec uni2
     bne dbpk_1
     rts

;----------------------------------------------------
;kopiuje 64 bajty (8x8) z bufora do pamieci ekranu od _arr
;czyli odtwarza znaki na ktorych byl klocek
odtworz_z_bufora
     mwa _arr ozb_2+1 ;wstawienie adresu
     lda #8
     sta uni2
     ldx #0
ozb_1
     ldy #7       ;8 znakow
ozb_2a
     lda bufor_pod_klockiem,x
ozb_2
     sta $FFFF,y      ;automodyfikowalny
     inx
     dey
     bpl ozb_2a
     ;dodaj 40 do adresu
     lda #40
     clc
     adc ozb_2+1
     sta ozb_2+1
     lda #0
     adc ozb_2+2
     sta ozb_2+2
     dec uni2
     bne ozb_1
     rts


;-----------------------------------
;wyswietla punkty
;!!! dla uproszczenia na razie wyswietlam tylko z 2 bajtow (16-bitowo max) !!!
;zeby to poprawic na 3 bajty trzeba zmienic procedure hex2bcd
punkty2pmg
     mwa punkty _arr
     jsr hex2bcd
     lda #32+16 ;pozycja Y napisu
     sta cB2p_2+1 ;taka sama dla wszystkich cyfr
     ;--pierwsza cyfra
     ldx #0   ;0 - wiodace 0, domyslnie
     lda #3   ;na pozycji pociskow
     sta uni2
     lda _arr3
     and #%00001111
     tax
     bne p2p_1
     lda #$0A
p2p_1
     jsr cyfraBCD2pmg
     ;--druga cyfra
     lda #4   ;na pozycji P0
     sta uni2
     lda _arr2+1
     lsr @
     lsr @
     lsr @
     lsr @
     bne p2p_3
     cpx #0    ;sprawdzamy czy poprzednio bylo wiodace 0
     bne p2p_3
     ;jak bylo to teraz jest dalej
     lda #$0A
     jmp p2p_4
p2p_3
     ldx #1 ;znacznik ze juz nie jest zero wiodace
p2p_4
     jsr cyfraBCD2pmg
     ;--trzecia cyfra
     lda #5   ;na pozycji P1
     sta uni2
     lda _arr2+1
     and #%00001111
     bne p2p_5
     cpx #0    ;sprawdzamy czy poprzednio bylo wiodace 0
     bne p2p_5
     ;jak bylo to teraz jest dalej
     lda #$0A
     jmp p2p_6
p2p_5
     ldx #1 ;znacznik ze juz nie jest zero wiodace
p2p_6
     jsr cyfraBCD2pmg
     ;--czwarta cyfra
     lda #6   ;na pozycji P2
     sta uni2
     lda _arr2
     lsr @
     lsr @
     lsr @
     lsr @
     bne p2p_7
     cpx #0    ;sprawdzamy czy poprzednio bylo wiodace 0
     bne p2p_7
     ;jak bylo to teraz jest dalej
     lda #$0A
     jmp p2p_8
p2p_7
     ldx #1 ;znacznik ze juz nie jest zero wiodace
p2p_8
     jsr cyfraBCD2pmg
     ;--piata cyfra
     lda #7   ;na pozycji P3
     sta uni2
     lda _arr2
     and #%00001111  ;tu juz nas zero nie obchodzi - piszemy
     jsr cyfraBCD2pmg
     rts

;-----------------------------
;wrzuca liczbe BCD 20-bit na do PMG
;mamy 4 cyfry, kazdy znak 16 linii wysokosci
;wiodace zera pomijamy
;uzywa X
licznik_czasu2pmg
     mwa licznik_czasu _arr
     jsr hex2bcd
     lda #32+16+16+8+16+16 ;pozycja Y napisu
     sta cB2p_2+1 ;taka sama dla wszystkich cyfr
     ;--pierwsza cyfra
     ldx #0   ;0 - wiodace 0, domyslnie
     lda #4   ;na pozycji P0
     sta uni2
     lda _arr2+1
     lsr @
     lsr @
     lsr @
     lsr @
     tax
     bne lc2p_1
     lda #$0A
lc2p_1
     jsr cyfraBCD2pmg
     ;--druga cyfra
     lda #5   ;na pozycji P1
     sta uni2
     lda _arr2+1
     and #%00001111
     bne lc2p_3
     cpx #0    ;sprawdzamy czy poprzednio bylo wiodace 0
     bne lc2p_3
     ;jak bylo to teraz jest dalej
     lda #$0A
     jmp lc2p_4
lc2p_3
     ldx #1 ;znacznik ze juz nie jest zero wiodace
lc2p_4
     jsr cyfraBCD2pmg
     ;--trzecia cyfra
     lda #6   ;na pozycji P2
     sta uni2
     lda _arr2
     lsr @
     lsr @
     lsr @
     lsr @
     bne lc2p_5
     cpx #0    ;sprawdzamy czy poprzednio bylo wiodace 0
     bne lc2p_5
     ;jak bylo to teraz jest dalej
     lda #$0A
     jmp lc2p_6
lc2p_5
     ldx #1 ;znacznik ze juz nie jest zero wiodace
lc2p_6
     jsr cyfraBCD2pmg
     ;--czwarta cyfra
     lda #7   ;na pozycji P3
     sta uni2
     lda _arr2
     and #%00001111  ;tu juz nas zero nie obchodzi - piszemy
     jsr cyfraBCD2pmg
     rts

;---------------------------------------------------
;wyswietla cyfre w A (0 - 9 i A),A oznacza spacje
;na duszku wskazanym przez uni2: 3 - pociski, 4 - P0, 5 - P1, 6 - P2, 7 - P3
;i pozycji pionowej wskazanej przez cB2p_2+1
cyfraBCD2pmg
     asl @
     tay
     lda cyfry_wskazy,y
     sta _arr
     lda cyfry_wskazy+1,y
     sta _arr+1  ;mamy adres danych cyfry
     ;ustalanie adresu docelowego
     lda #<pmg_memory_1
     clc
cB2p_2
     adc #0 ;automodyfikowana
     sta cB2p_3+1
     lda #>pmg_memory_1
     adc uni2
     sta cB2p_3+2
     ;--
     ldy #15
cB2p_1
     lda (_arr),y
cB2p_3
     sta pmg_memory_1,y
     dey
     bpl cB2p_1
     rts
cyfry_wskazy
     dta a(napis_0),a(napis_1),a(napis_2),a(napis_3),a(napis_4),a(napis_5),a(napis_6),a(napis_7),a(napis_8),a(napis_9),a(napis_spacja)

;-----------------------------
;wrzuca napis do PMG
;napis ma zawsze 5 znakow, kazdy znak 16 linii wysokosci
;adres napisu w _arr
;pozycja pionowa w X
napis2pmg
     ldy #0
     lda #16
     sta uni2
n2p_1
     lda (_arr),y
     sta pmg_memory_1+$300,x
     inc _arr          ;mozna tak, bo napisy sa od pelnej strony i zajmuja nie wiecej niz strone
     lda (_arr),y
     sta pmg_memory_1+$400,x
     inc _arr
     lda (_arr),y
     sta pmg_memory_1+$500,x
     inc _arr
     lda (_arr),y
     sta pmg_memory_1+$600,x
     inc _arr
     lda (_arr),y
     sta pmg_memory_1+$700,x
     inc _arr
     inx
     dec uni2
     bne n2p_1
     rts

;----------------------------
;wstawia FF
FF_tabele_odpowiedzi_linii
    ldy #15
    lda #$FF
ztol_1
    sta tabela_odpowiedzi_linii_poziom,y
    sta tabela_odpowiedzi_linii_pion,y
    dey
    bpl ztol_1
    rts

;-----------------------------
ustaw_i_wlacz_przerwania
     ;ustawienie przerwania DLI
     lda #<dli_1
     sta VDSLST
     lda #>dli_1
     sta VDSLST+1
     ;ustawienie przerwania VBI
     ldy #<vbli
     ldx #>vbli
     lda #$06
     jsr jsetvblv
     lda #64  ;wlaczenie tylko VBL
     sta NMIEN
     rts

;---------------------------------------
;odpalane kiedy licznik czasu osiagnie 0
;albo kiedy stwierdzi sie wygrana
;przegrana/wygrana kodowana na A (0 - wygrana, 1 - przegrana)
obsluz_przegrana_wygrana
     sta oprz_5+1       ;zapis do automodyfikowanego
     ;wylaczenie muzyki
     LDA  #$40
     JSR  REPLAY+3
     ;wylaczenie przerwan
     lda #0
     sta NMIEN

     ;doliczenie wszystkich punktow z bufora do wyniku
     lda punkty_bufor
     clc
     adc punkty
     sta punkty
     lda punkty_bufor+1
     adc punkty+1
     sta punkty+1
     lda #0
     adc punkty+2
     sta punkty+2

     ;doliczenie czasu do punktow 
     ;ma to sens przy wygranej, bo przy przegranej dodajemy 0
     lda licznik_czasu
     clc
     adc punkty
     sta punkty
     lda licznik_czasu+1
     adc punkty+1
     sta punkty+1

     jsr punkty2pmg   ;wyswietla punkty na duszkach

     jsr zeruj_miejsce_na_next_klocek ;zeby napis dobrze wygladal

     ;skasowanie pionowego paska czasu klocka
     ldx #32+16+16+8+16+16+8+24+16+16
     lda #0
oprz_2
     sta pmg_memory_1+$700,x
     inx
     bne oprz_2
oprz_5
     lda #0    ;automodyfikowany
     beq oprz_3

     ;pisz GAME OVER
     mwa #napis_GAME _arr
     ldx #32+16+16+8+16   ;pozycja Y
     jsr napis2pmg
     mwa #napis_OVER _arr
     ldx #32+16+16+8+16+16   ;pozycja Y
     jsr napis2pmg
     jmp oprz_4
oprz_3
     ;pisz YOU WIN
     mwa #napis_YOU _arr
     ldx #32+16+16+8+16   ;pozycja Y
     jsr napis2pmg
     mwa #napis_WIN _arr
     ldx #32+16+16+8+16+16   ;pozycja Y
     jsr napis2pmg
oprz_4
     ;pisz PRESS SPACE
     mwa #napis_PRESS _arr
     ldx #32+16+16+8+16+16+8+24   ;pozycja Y
     jsr napis2pmg
     mwa #napis_SPACE _arr
     ldx #32+16+16+8+16+16+8+24+16   ;pozycja Y
     jsr napis2pmg

     ;czekaj na nacisniecie spacji
oprz_1
     lda 764
     cmp #$21
     bne oprz_1
     lda #$ff    ; ustawiamy na $FF ostatnio wcisniety klawisz
     sta 764
     rts

;---------------------------------
;trzeba odpalic raz na poczatku uruchomienia programu
inicjalizacja_gry
     mwa #pamiec_ekranu obr  ;---ustawienia pamieci obrazu
     mwa #dl dliadr     ;ustawienie DL

     jsr czysc_ekran
     jsr czysc_PMG

     ;ustawienia kolorow
     lda #$FE
     sta COLOR4
     lda #$10
     sta COLOR0
     lda #$16
     sta COLOR1
     lda #$AA
     sta COLOR2
     lda #$2A
     sta COLOR3

     ;---wyzerowanie zmiennych na stronie 0
     ldy #$80
     lda #0
glow4
     sta $0,y
     iny
     bne glow4

     ;przelaczenie zestawu znakow
     lda #>fonty
     sta CHBAS

     ;------inicjalizacja PMG-------
     jsr inicjalizacja_PMG

     rts


;---------------------------------
;trzeba odpalic przed rozpoczeciem kazdej nowej gry
;przedtem wylaczyc przerwania!
inicjalizajca_rozgrywki
     jsr czysc_ekran
     jsr czysc_PMG

     ;ustawiamy pozycje X dla graczy i pociskow
     lda #pozycja_X_P0
     sta HPOSM3
     lda #pozycja_X_P0+2
     sta HPOSM2
     lda #pozycja_X_P0+4
     sta HPOSM1
     lda #pozycja_X_P0+6
     sta HPOSM0
     lda #pozycja_X_P0+8
     sta HPOSP0
     lda #pozycja_X_P0+16
     sta HPOSP1
     lda #pozycja_X_P0+24
     sta HPOSP2
     lda #pozycja_X_P0+32
     sta HPOSP3

     ;tlo panelu
     jsr wypelnij_panel

     ;zmienne
     lda #0
     sta fire_licznik
     lda #0
     sta czy_mozna_postawic
     lda #0
     sta mrugaj_liniami_poziomymi
     sta mrugaj_liniami_pionowymi
     lda #0
     sta byl_fire_wycisniety ;do obslugi joya - fire byl zwolniony
     lda #0
     sta przesun_czas

     ;ustawienie pozycji pierwszego klocka
     lda #10
     sta klocek_X
     sta klocek_Y
     mwa #pamiec_ekranu+$19A klocek_adr

     ;przelozenie bajtow z ekranu do bufora
     mwa klocek_adr _arr
     jsr do_bufora_pod_klockiem
     jsr losuj_klocek
     sta klocek
     jsr losuj_klocek
     sta klocek_next

     ;rysowanie nastepnego klocka
     jsr zeruj_miejsce_na_next_klocek
     mwa #gdzie_rys_next_klocek _arr
     ldx #5         ;znak dla stawianego klocka
     lda klocek_next
     jsr wyswietl_klocek

     ;naniesienie 4 jokerow na ekran
     mwa #pamiec_ekranu _arr
     lda #9
     jsr rysuj_kwadrat
     mwa #pamiec_ekranu+22 _arr
     lda #9
     jsr rysuj_kwadrat
     mwa #pamiec_ekranu+40*22 _arr
     lda #9
     jsr rysuj_kwadrat
     mwa #pamiec_ekranu+40*22+22 _arr
     lda #9
     jsr rysuj_kwadrat

     jsr FF_tabele_odpowiedzi_linii

     ;ustawianie licznikow i punktow
     mwa #$270F licznik_czasu
     lda #0
     sta licznik_klocka
     lda #0
     sta punkty
     sta punkty+1
     sta punkty+2
     sta punkty_bufor
     sta punkty_bufor+1
     sta punkty_bufor+2
     jsr punkty2pmg   ;wyswietla punkty na duszkach

     ;napis SCORE
     mwa #napis_SCORE _arr
     ldx #32   ;pozycja Y
     jsr napis2pmg
     ;napis TIME
     mwa #napis_TIME _arr
     ldx #32+16+16+8+16   ;pozycja Y
     jsr napis2pmg
     ;napis NEXT
     mwa #napis_NEXT _arr
     ldx #32+16+16+8+16+16+8+24   ;pozycja Y
     jsr napis2pmg
     ;inicjalizacja muzyki
        LDX  #<MUSADR
        LDY  #>MUSADR
        LDA  #$70
        JSR  REPLAY+3    ;Initialize
        LDX  #0
        TXA
        JSR  REPLAY+3    ;Play the first song
     ;zeby zlapac synchronizacje w petli glownej
     lda licznik
     sta licznik_old
     rts


;---------------------------------------
;zwraca 0 jak wygralismy, 1 jak nie
;uzywa x
czy_wygralismy
     ldx #0 ;domyslnie wygralismy
     lda pamiec_ekranu+10*40+10
     cmp #9
     bne cz_wy_1
     lda pamiec_ekranu+10*40+12
     cmp #9
     bne cz_wy_1
     lda pamiec_ekranu+12*40+10
     cmp #9
     bne cz_wy_1
     lda pamiec_ekranu+12*40+12
     cmp #9
     bne cz_wy_1
     lda #0 ;pozywtywnie
     rts
cz_wy_1
     lda #1  ;negatywnie
     rts

;---------------------------------------
;konwertuje 16bit liczbe zawarta w _arr
;na bcd (0 - 99) w _arr2,_arr2+1,_arr3
;zmienia _arr, _arr2, _arr3
Hex2Bcd
	        SED		; Switch to decimal mode
		LDA #0		; Ensure the result is clear
		STA _arr2+0
		STA _arr2+1
		STA _arr2+2
		LDX #16		; The number of source bits

CNVBIT		ASL _arr+0	; Shift out one bit
		ROL _arr+1
		LDA _arr2+0	; And add into result
		ADC _arr2+0
		STA _arr2+0
		LDA _arr2+1	; propagating any carry
		ADC _arr2+1
		STA _arr2+1
		LDA _arr2+2	; ... thru whole result
		ADC _arr2+2
		STA _arr2+2
		DEX		; And repeat for next bit
		BNE CNVBIT
		CLD		; Back to binary
                rts

;-------------------------------------
;czysci $0 pamiec_ekranu 960 bajtow
;uzywa a, y, x
czysc_ekran
    mwa #pamiec_ekranu cmr_4+1
    ldy #120
    lda #0
cmr_1
    ldx #8
cmr_4
    sta pamiec_ekranu
    inc cmr_4+1
    bne cmr_2
    inc cmr_4+2
cmr_2
    dex
    bne cmr_4
    dey
    bne cmr_1
    rts


;----------------------
;losuje liczbe 0 - 8
;wynik zwraca w A
losuj_klocek
    lda RANDOM
    and #%00001111    ;mamy od 0 do 15
    cmp #9   ;jak >=9 to losuj jeszcze raz
    bcs losuj_klocek
    rts

;-------------------------------------
;czysci $0 obszar PMG 5x256B
;uzywa a, y, x
czysc_PMG
    ldy #0
    lda #0
cPMG_1
    sta pmg_memory_1+$300,y
    sta pmg_memory_1+$400,y
    sta pmg_memory_1+$500,y
    sta pmg_memory_1+$600,y
    sta pmg_memory_1+$700,y
    dey
    bne cPMG_1
    rts

;-----------------------------------------
;przerwanie VBLI - synchro pionowej - w czasie gry
vbli
    php
    pha
    tya
    pha
    txa
    pha
    ;dopiero teraz mozna wlaczyc DLI
    lda #128+64  ;wlaczenie DLI + VBL  bedzie automodyfikowane
    sta NMIEN
    ;--joy
    lda STICK0
    sta stan_joya
    lda TRIG0S
    sta fire
;    ;--liczniki
;    lda licznik_czasu   ;16-bitowo w dol do 0
;    bne vb_1
;    lda licznik_czasu+1
;    beq vb_2
;vb_1
;    dec licznik_czasu
;    lda licznik_czasu
;    cmp #$FF
;    bne vb_1a
;    dec licznik_czasu+1
;vb_1a
;    sed ;BCD
;    lda licznik_czasu
;    sec
;    sbc #1
;    sta licznik_czasu
;    lda licznik_czasu+1
;    sbc #0
;    sta licznik_czasu+1
;    cld
vb_2
    ;ustawiamy kolory napisu score
    lda #kolor_napisu_score
    sta COLPM0S       ;tu trzeba do cienia
    sta COLPM1S
    sta COLPM2S
    sta COLPM3S
    ;--
    pla
    tax
    pla
    tay
    pla
    plp
    jmp sysvbv

;------------------------------
dli_1
   php
   sta dli_1_1+1
   lda #kolor_napisu_time
   ;wait__line
   sta WSYNC    ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_2 VDSLST
dli_1_1
   lda #0 ;automodyfikacja
   plp
   rti

dli_2
   php
   sta dli_2_1+1
   lda #kolor_napisu_next
   ;wait__line
   sta WSYNC 
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_3 VDSLST
dli_2_1
   lda #0 ;automodyfikacja
   plp
   rti

dli_3
   php
   sta dli_3_1+1
   lda #$3A
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_4 VDSLST
dli_3_1
   lda #0 ;automodyfikacja
   plp
   rti

dli_4
   php
   sta dli_4_1+1
   lda #$3C
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_5 VDSLST
dli_4_1
   lda #0 ;automodyfikacja
   plp
   rti
   
dli_5
   php
   sta dli_5_1+1
   lda #$CE
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_6 VDSLST
dli_5_1
   lda #0 ;automodyfikacja
   plp
   rti

dli_6
   php
   sta dli_6_1+1
   lda #$CC
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_7 VDSLST
dli_6_1
   lda #0 ;automodyfikacja
   plp
   rti

dli_7
   php
   sta dli_7_1+1
   lda #$CA
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_8 VDSLST
dli_7_1
   lda #0 ;automodyfikacja
   plp
   rti
   
dli_8
   php
   sta dli_8_1+1
   lda #$C8
   ;wait__line
   sta WSYNC
      ;zapis czegokolwiek
   sta COLPM0
   sta COLPM1
   sta COLPM2
   sta COLPM3
   mwa #dli_1 VDSLST
dli_8_1
   lda #0 ;automodyfikacja
   plp
   rti

;tu beda przechowywane dane ekranu pod obracanym klockiem
bufor_pod_klockiem
:64  dta 0

;tu zapisujemy ktore linie poziome sa pelne po postawieniu klocka
;max 4 w poziomie
;na pierwszym bajcie pozycja Y
;na 2 kolejnych adres poczatku linii lub kolumny
;ostatni bajt dodany zeby wyrownac do 4
tabela_odpowiedzi_linii_poziom
:4   dta 0,0,0,0

;tu zapisujemy ktore linie pionowe sa pelne po postawieniu klocka
;max 4 w pionie
;na pierwszych 4 bajtach pozycje X pelnych linii
;kolejne 12 bajtow dodane zeby zachowac zgodnosc.
tabela_odpowiedzi_linii_pion
:4   dta 0,0,0,0


;=================== DANE ==================

;--granice przesuwania klockow
;do ktorego znaku mozna przesunac klocek w poziomie,pionie
granice_przesuwania
    dta 22,22 ;0
    dta 20,20 ;1
    dta 20,20 ;2
    dta 22,16 ;3
    dta 20,18 ;4
    dta 20,18 ;5
    dta 20,18 ;6
    dta 20,18 ;7
    dta 20,18 ;8
    dta 20,20 ;9
    dta 16,22 ;10
    dta 18,20 ;11
    dta 20,18 ;12
    dta 18,20 ;13
    dta 18,20 ;14
    dta 20,18 ;15
    dta 18,20 ;16
    dta 18,20 ;17
    dta 18,20 ;18
    dta 20,18 ;19
    dta 18,20 ;20
    dta 18,20 ;21
    dta 22,16 ;22
    dta 16,22 ;23
    dta 20,18 ;24
    dta 18,20 ;25
    dta 20,18 ;26
    dta 18,20 ;27

;--w jaki klocek zmieni sie obecny klocek po obrocie
kolejnosc_obrotow_tab
    dta 0      ;0
    dta 1      ;1
    dta 9      ;2
    dta 10     ;3
    dta 11     ;4
    dta 14     ;5
    dta 17     ;6
    dta 18     ;7
    dta 21     ;8
    dta 2      ;9
    dta 22      ;10
    dta 12     ;11
    dta 13     ;12
    dta 4      ;13
    dta 15     ;14
    dta 16     ;15
    dta 5      ;16
    dta 24     ;17
    dta 19     ;18
    dta 20     ;19
    dta 7      ;20
    dta 26     ;21
    dta 23     ;22
    dta 3      ;23
    dta 25     ;24
    dta 6      ;25
    dta 27     ;26
    dta 8      ;27


;---o ile przesunac X,Y klocka przy stawianiu na planszy
;wykorzystywane do bardziej eleganckich obrotow
o_ile_przesunac
    dta 0,0   ;0
    dta 0,0   ;1
    dta 0,0   ;2
    dta 0,0   ;3
    dta 0,0   ;4
    dta 0,0   ;5
    dta 0,0   ;6
    dta 0,0   ;7
    dta 0,0   ;8
    dta 0,0   ;9
    dta 0,6  ;10
    dta 0,2   ;11
    dta 2,-2   ;12
    dta -2,0   ;13
    dta 0,2   ;14
    dta 2,-2   ;15
    dta -2,0   ;16
    dta 0,2   ;17
    dta 0,2   ;18
    dta 2,-2   ;19
    dta -2,0   ;20
    dta 0,2   ;21
    dta 6,-6   ;22
    dta -6,0  ;23
    dta 2,-2   ;24
    dta -2,0   ;25
    dta 2,-2   ;26
    dta -2,0   ;27

;--klocki--
;kazdy ma 4 bajty, 4 kolumny (starsze bity), 4 rzedy
klocki_tab
    ;te od 0 do 8 sa losowane
    ;klocek 0
    dta %10000000
    dta %00000000
    dta %00000000
    dta %00000000
    ;klocek 1
    dta %11000000
    dta %11000000
    dta %00000000
    dta %00000000
    ;klocek 2
    dta %01000000
    dta %10000000
    dta %00000000
    dta %00000000
    ;klocek 3
    dta %10000000
    dta %10000000
    dta %10000000
    dta %10000000
    ;klocek 4
    dta %01000000
    dta %01000000
    dta %11000000
    dta %00000000
    ;klocek 5
    dta %11000000
    dta %01000000
    dta %01000000
    dta %00000000
    ;klocek 6
    dta %10000000
    dta %11000000
    dta %01000000
    dta %00000000
    ;klocek 7
    dta %01000000
    dta %11000000
    dta %01000000
    dta %00000000
    ;klocek 8
    dta %01000000
    dta %11000000
    dta %10000000
    dta %00000000
    ;--te sa wykorzystywane do obrotow
    ;klocek 9  (obrot 2)
    dta %10000000
    dta %01000000
    dta %00000000
    dta %00000000
    ;klocek 10 (obrot 3)
    dta %11110000
    dta %00000000
    dta %00000000
    dta %00000000
    ;klocek 11 (obrot 4)
    dta %11100000
    dta %00100000
    dta %00000000
    dta %00000000
    ;klocek 12 (obrot 11)
    dta %11000000
    dta %10000000
    dta %10000000
    dta %00000000
    ;klocek 13 (obrot 12)
    dta %10000000
    dta %11100000
    dta %00000000
    dta %00000000
    ;klocek 14 (obrot 5)
    dta %11100000
    dta %10000000
    dta %00000000
    dta %00000000
    ;klocek 15 (obrot 14)
    dta %10000000
    dta %10000000
    dta %11000000
    dta %00000000
    ;klocek 16 (obrot 15)
    dta %00100000
    dta %11100000
    dta %00000000
    dta %00000000
    ;klocek 17 (obrot 6)
    dta %01100000
    dta %11000000
    dta %00000000
    dta %00000000
    ;klocek 18 (obrot 7)
    dta %11100000
    dta %01000000
    dta %00000000
    dta %00000000
    ;klocek 19 (obrot 18)
    dta %10000000
    dta %11000000
    dta %10000000
    dta %00000000
    ;klocek 20 (obrot 19)
    dta %01000000
    dta %11100000
    dta %00000000
    dta %00000000
    ;klocek 21 (obrot 8)
    dta %11000000
    dta %01100000
    dta %00000000
    dta %00000000
    ;klocek 22 (obrot 10)
    dta %10000000
    dta %10000000
    dta %10000000
    dta %10000000
    ;klocek 23 (obrot 22)
    dta %11110000
    dta %00000000
    dta %00000000
    dta %00000000
    ;klocek 24 (obrot 17)
    dta %10000000
    dta %11000000
    dta %01000000
    dta %00000000
    ;klocek 25 (obrot 24)
    dta %01100000
    dta %11000000
    dta %00000000
    dta %00000000
    ;klocek 26  (obrot 21)
    dta %01000000
    dta %11000000
    dta %10000000
    dta %00000000
    ;klocek 27 (obrot 26)
    dta %11000000
    dta %01100000
    dta %00000000
    dta %00000000

    org $7000
REPLAY
    	opt h-
	ins "flying.rep"
	opt h+
    org $8400
MUSADR
    	opt h-
	ins "flying.cmc"
	opt h+
